#include <stdio.h>

#define MAXN 300000

typedef struct {
    long long x, y;
} Vec;

Vec v[MAXN];
int n;

long long dot(Vec a, Vec b) {
    return a.x * b.x + a.y * b.y;
}

int main() {
    int i, j;
    scanf("%d", &n);

    for (i = 0; i < n; i++) {
        scanf("%lld %lld", &v[i].x, &v[i].y);
    }

    long long best = 0;
    int bestCount = 0;
    int bestIdx[MAXN];

    for (i = 0; i < n; i++) {
        long long sx = 0, sy = 0;
        int cnt = 0;
        int tmp[MAXN];

        for (j = 0; j < n; j++) {
            if (dot(v[i], v[j]) > 0) {
                sx += v[j].x;
                sy += v[j].y;
                tmp[cnt++] = j + 1;
            }
        }

        long long val = sx * sx + sy * sy;
        if (val > best) {
            best = val;
            bestCount = cnt;
            for (j = 0; j < cnt; j++)
                bestIdx[j] = tmp[j];
        }
    }

    printf("%d\n", bestCount);
    for (i = 0; i < bestCount; i++)
        printf("%d ", bestIdx[i]);
    printf("\n");

    return 0;
}